#include <iostream>

// MyFirstService header file
#include "gen-cpp/MyFirstService.h"

#include <transport/TSocket.h>
#include <transport/TBufferTransports.h>
#include <protocol/TBinaryProtocol.h>

using namespace apache::thrift;
using namespace apache::thrift::protocol;
using namespace apache::thrift::transport;

using namespace std;

using namespace myfirst;

int main(int argc, char **argv) {
    boost::shared_ptr<TSocket> socket(new TSocket("localhost", 8080));
    boost::shared_ptr<TTransport> transport(new TBufferedTransport(socket));
    boost::shared_ptr<TProtocol> protocol(new TBinaryProtocol(transport));

    MyFirstServiceClient client(protocol);

    transport->open();

    client.log("logfile.log");

    cout << client.multiply(6,7) << endl;
    transport->close();

    return 0;
}